/**
******************************************************************************
* @file    			w5500_conf.c                                                                                              
* @version 			V1.2										  		
* @date    			2017-11-01								 
* @brief 				3.5.0汾⽨Ĺģ						  	
* @attention		MCUֲw5500Ҫ޸ĵļw5500MACIPַ 	
*				
* @company  		Ƽ޹˾
* @information  WIZnet W5500ٷ̣ȫ̼֧֣۸ƣ
* @website  		www.wisioe.com																							 	 				
* @forum        www.w5500.cn																								 		
* @qqGroup      383035001																										 
******************************************************************************
*/

/*
add by Gavin 2020.03
RST -PA15
CS  -PB14
INT -PB15
SPI -sys_SPI3(PC10-clk;PC11 MISO;PC12 -MOSI;

 οԭͼ֪w5500NFCϵͳspi3,
 ĿǰNFCõģspiҪ޸ģ
 ر˵ RSTλҲǹãӲȱݣԳʼǰִһθλ;
 ʼǸģ鲻ִиλˣ...
 
 NFC ic RC522spiٶ10M
 w5500  SPIٶ 80M
 system SPI3 ٶ 21.5M
 ϵͳSPIֻó3СǸ 10M;
 ̲ο http://www.w5500.cn
 //---------------------------
1,DEMO_W5500ĺ궨 demoеĿӲϢ
2, ʵʵԣNFC ic-RC522ֻSPI3 8Ƶ=5Mͨţ4ƵʵʲԲͨ!!!!!!!!!!!!

*/
#include <stdio.h> 
#include <string.h>
#include "w5500_conf.h"
#include "utility.h"
#include "w5500.h"
#include "dhcp.h"
#include "platform_interface.h"
#include "function_interface.h"
#include "function.h"
#include "tcp_demo.h"
#include "platform.h"

//next 3 header file mask by Gavin 
//#include "bsp_i2c_ee.h"
//#include "bsp_spi_flash.h"
//#include "bsp_TiMbase.h"
 
//add by Gavin 
extern SPI_HandleTypeDef hspi3;

#ifndef DEMO_W5500
#define 	W5500_CS_PORT			GPIOB
#define 	W5500_CS_PIN			GPIO_PIN_14	
#define 	SET_W5500_CS  		HAL_GPIO_WritePin(W5500_CS_PORT,W5500_CS_PIN,GPIO_PIN_SET)
#define 	RESET_W5500_CS  	HAL_GPIO_WritePin(W5500_CS_PORT,W5500_CS_PIN,GPIO_PIN_RESET)


#endif 




CONFIG_MSG  ConfigMsg;																	/*ýṹ*/
EEPROM_MSG_STR EEPROM_MSG;															/*EEPROM洢Ϣṹ*/

/*MACַֽڱΪż*/
/*W5500ͬһֳʹòͬMACַ*/
uint8 mac[6]={0x00,0x08,0xdc,0x11,0x11,0x11};

/*ĬIPϢ*/
uint8 local_ip[4]={192,168,0,12};												/*W5500ĬIPַ*/
uint8 subnet[4]={255,255,255,0};												/*W5500Ĭ*/
uint8 gateway[4]={200,200,100,1}; //{192,168,1,1};													/*W5500Ĭ*/
uint8 dns_server[4]={114,114,114,114};									/*W5500ĬDNS*/

uint16 local_port=4000;//8000;	                    						/*屾ض˿*/

/*ԶIPϢ*/
uint8  remote_ip[4]={192,168,1,107};										/*ԶIPַ*/
uint16 remote_port=8080;																/*Զ˶˿ں*/

/*IP÷ѡѡ*/
uint8  ip_from=IP_FROM_DEFINE;				

uint8  dhcp_ok=0;																				/*dhcpɹȡIP*/
uint32 ms=0;																						/**/
uint32 dhcp_time= 0;																		/*DHCPм*/
vu8    ntptimer = 0;																		/*NPT*/

/**
*@brief		W5500IPַ
*@param		
*@return	
*/
void set_w5500_ip(void)
{	
		
  /*ƶϢýṹ*/
	memcpy(ConfigMsg.mac, mac, 6);
	memcpy(ConfigMsg.lip,local_ip,4);
	memcpy(ConfigMsg.sub,subnet,4);
	memcpy(ConfigMsg.gw,gateway,4);
	memcpy(ConfigMsg.dns,dns_server,4);
	if(ip_from==IP_FROM_DEFINE){	
		//printf(" ʹöIPϢW5500:\r\n");
	}
	/*ʹEEPROM洢IP*/	
	if(ip_from==IP_FROM_EEPROM)
	{
		/*EEPROMжȡIPϢ*/
		read_config_from_eeprom();		
		
		/*ȡEEPROMMACϢ,ãʹ*/		
		if( *(EEPROM_MSG.mac)==0x00&& *(EEPROM_MSG.mac+1)==0x08&&*(EEPROM_MSG.mac+2)==0xdc)		
		{
			//printf(" IP from EEPROM\r\n");
			/*EEPROMϢõĽṹ*/
			memcpy(ConfigMsg.lip,EEPROM_MSG.lip, 4);				
			memcpy(ConfigMsg.sub,EEPROM_MSG.sub, 4);
			memcpy(ConfigMsg.gw, EEPROM_MSG.gw, 4);
		}
		else
		{
			//printf(" EEPROMδ,ʹöIPϢW5500,дEEPROM\r\n");
			write_config_to_eeprom();	/*ʹĬϵIPϢʼEEPROM*/
		}			
	}

	/*ʹDHCPȡIPDHCPӺ*/		
	if(ip_from==IP_FROM_DHCP)								
	{
		/*DHCPȡϢýṹ*/
		if(dhcp_ok==1)
		{
			//printf(" IP from DHCP\r\n");		 
			memcpy(ConfigMsg.lip,DHCP_GET.lip, 4);
			memcpy(ConfigMsg.sub,DHCP_GET.sub, 4);
			memcpy(ConfigMsg.gw,DHCP_GET.gw, 4);
			memcpy(ConfigMsg.dns,DHCP_GET.dns,4);
		}
		else
		{
			//printf(" DHCPӳδ,߲ɹ\r\n");
			//printf(" ʹöIPϢW5500\r\n");
		}
	}
		
	/*ϢҪѡ*/	
	ConfigMsg.sw_ver[0]=FW_VER_HIGH;
	ConfigMsg.sw_ver[1]=FW_VER_LOW;	

	/*IPϢдW5500ӦĴ*/	
	setSUBR(ConfigMsg.sub);
	setGAR(ConfigMsg.gw);
	setSIPR(ConfigMsg.lip);
	
	getSIPR (local_ip);			
	//printf(" W5500 IPַ   : %d.%d.%d.%d\r\n", local_ip[0],local_ip[1],local_ip[2],local_ip[3]);
	getSUBR(subnet);
	//printf(" W5500  : %d.%d.%d.%d\r\n", subnet[0],subnet[1],subnet[2],subnet[3]);
	getGAR(gateway);
	//printf(" W5500      : %d.%d.%d.%d\r\n", gateway[0],gateway[1],gateway[2],gateway[3]);
	
}

/**
*@brief		W5500MACַ
*@param		
*@return	
*/
void set_w5500_mac(void)
{
	memcpy(ConfigMsg.mac, mac, 6);
	setSHAR(ConfigMsg.mac);	/**/
	memcpy(DHCP_GET.mac, mac, 6);
}






/**
*@brief		W5500GPIOӿ
*@param		
*@return	
*/
void gpio_for_w5500_config(void)
{
	#ifdef DEMO_W5500 //add by Gavin
	GPIO_InitTypeDef GPIO_InitStructure;
	SPI_FLASH_Init();																		 /*ʼSTM32 SPIӿ*/
	RCC_APB2PeriphClockCmd(RCC_APB2Periph_GPIOB|RCC_APB2Periph_GPIOC|RCC_APB2Periph_GPIOE|RCC_APB2Periph_GPIOG, ENABLE);
		
	/*ʹSPI1*/
	#ifdef STM32_SPI1
		/*RESET*/	
		GPIO_InitStructure.GPIO_Pin = GPIO_Pin_0;						 /*ѡҪƵGPIO*/		 
		GPIO_InitStructure.GPIO_Speed = GPIO_Speed_50MHz;		 /*Ϊ50MHz*/		
		GPIO_InitStructure.GPIO_Mode = GPIO_Mode_Out_PP;		 /*ģʽΪͨ*/		
		GPIO_Init(GPIOC, &GPIO_InitStructure);							 /*ÿ⺯ʼGPIO*/
		GPIO_SetBits(GPIOC, GPIO_Pin_0);		
		/*INT*/	
		GPIO_InitStructure.GPIO_Pin = GPIO_Pin_1;						 /*ѡҪƵGPIO*/		 
		GPIO_InitStructure.GPIO_Speed = GPIO_Speed_50MHz;		 /*Ϊ50MHz */		
		GPIO_InitStructure.GPIO_Mode = GPIO_Mode_IPU;				 /*ģʽΪͨģ*/	
		GPIO_Init(GPIOC, &GPIO_InitStructure);							 /*ÿ⺯ʼGPIO*/
	#endif
  
	/*ʹSPI2*/
	#ifdef  STM32_SPI2
		/*RESET*/	
		GPIO_InitStructure.GPIO_Pin = GPIO_Pin_9;						 /*ѡҪƵGPIO*/		 
		GPIO_InitStructure.GPIO_Speed = GPIO_Speed_50MHz;		 /*Ϊ50MHz*/		
		GPIO_InitStructure.GPIO_Mode = GPIO_Mode_Out_PP;		 /*ģʽΪͨ*/		
		GPIO_Init(GPIOB, &GPIO_InitStructure);							 /*ÿ⺯ʼGPIO*/
		GPIO_SetBits(GPIOB, GPIO_Pin_9);		
		/*INT*/	
		GPIO_InitStructure.GPIO_Pin = GPIO_Pin_6;						 /*ѡҪƵGPIO*/		 
		GPIO_InitStructure.GPIO_Speed = GPIO_Speed_50MHz;		 /*Ϊ50MHz */		
		GPIO_InitStructure.GPIO_Mode = GPIO_Mode_IPU;				 /*ģʽΪͨģ*/	
		GPIO_Init(GPIOC, &GPIO_InitStructure);							 /*ÿ⺯ʼGPIO*/
	#endif
	#else 
		GPIO_InitTypeDef GPIO_InitStruct = {0};
	 
		GPIO_InitStruct.Pin = W5500_CS_PIN;
		GPIO_InitStruct.Mode = GPIO_MODE_OUTPUT_PP;
		GPIO_InitStruct.Pull = GPIO_NOPULL;
		GPIO_InitStruct.Speed = GPIO_SPEED_FREQ_VERY_HIGH;
		HAL_GPIO_Init(W5500_CS_PORT, &GPIO_InitStruct);		

	#endif
}

/**
*@brief		W5500Ƭѡźú
*@param		val: Ϊ0ʾƬѡ˿ΪͣΪ1ʾƬѡ˿Ϊ
*@return	
*/
void wiz_cs(uint8_t val)
{
#ifdef DEMO_W5500 //add by Gavin
	#ifdef  STM32_SPI1
		if (val == LOW) 
		{
			GPIO_ResetBits(GPIOA, GPIO_Pin_4); 
		}
		else if (val == HIGH)
		{
			GPIO_SetBits(GPIOA, GPIO_Pin_4); 
		}
	#endif
	#ifdef STM32_SPI2
		if (val == LOW) 
		{
			GPIO_ResetBits(GPIOB, GPIO_Pin_12); 
		}
		else if (val == HIGH)
		{
			GPIO_SetBits(GPIOB, GPIO_Pin_12); 
		}
	#endif
#else	
		if (val == LOW) 
		{
			RESET_W5500_CS;//GPIO_ResetBits(GPIOB, GPIO_Pin_12); 
		}
		else if (val == HIGH)
		{
			SET_W5500_CS;//GPIO_SetBits(GPIOB, GPIO_Pin_12); 
		}
#endif
}

/**
*@brief		W5500Ƭѡ˿SCSnΪ
*@param		
*@return	
*/
void iinchip_csoff(void)
{
	wiz_cs(LOW);
}

/**
*@brief		W5500Ƭѡ˿SCSnΪ
*@param		
*@return	
*/
void iinchip_cson(void)
{	
   wiz_cs(HIGH);
}


/*
2019.12.04 ʵ1ms;
Ƶ168MHz,رж,IOȡʾ!!	*/
void w5500_delay_ms( unsigned short  time )
{
    unsigned short  i = 0;
    while( time-- ){
			i = 33400;
			while( i-- );
    }
}

/**
*@brief		W5500λú
*@param		
*@return	
*/
void reset_w5500(void)
{
#ifdef DEMO_W5500 //add by Gavin	
	#ifdef STM32_SPI1
		GPIO_ResetBits(GPIOC, GPIO_Pin_0);
		delay_us(2);  
		GPIO_SetBits(GPIOC, GPIO_Pin_0);
		delay_ms(1600);	
	#endif
	#ifdef  STM32_SPI2
		GPIO_ResetBits(GPIOB, GPIO_Pin_9);
		delay_us(2);  
		GPIO_SetBits(GPIOB, GPIO_Pin_9);
		delay_ms(1600);
	#endif
#endif
	
	if( get_hard_flag() ==0){	//200S_V3 w5500 RST-PA8
		GPIO_InitTypeDef GPIO_InitStruct = {0};
	 
		GPIO_InitStruct.Pin = GPIO_PIN_8;
		GPIO_InitStruct.Mode = GPIO_MODE_OUTPUT_PP;
		GPIO_InitStruct.Pull = GPIO_NOPULL;
		GPIO_InitStruct.Speed = GPIO_SPEED_FREQ_VERY_HIGH;
		HAL_GPIO_Init(GPIOA, &GPIO_InitStruct);		
		
		//
		HAL_GPIO_WritePin(GPIOA, GPIO_PIN_8, GPIO_PIN_RESET);
		w5500_delay_ms(50);	
		HAL_GPIO_WritePin(GPIOA, GPIO_PIN_8, GPIO_PIN_SET);
		w5500_delay_ms(50);	
	}	
	
}

/**
*@brief		STM32 SPI1д8λ
*@param		datд8λ
*@return	
*/
uint8  IINCHIP_SpiSendData(uint8 dat)
{
#ifdef DEMO_W5500 //add by Gavin	
	return(SPI_FLASH_SendByte(dat));
#else		
	unsigned char rxdata;
	HAL_SPI_TransmitReceive(&hspi3,&dat,&rxdata,1,100);
	return rxdata;	
#endif 

}

/**
*@brief		дһ8λݵW5500
*@param		addrbsb: дݵĵַ
*@param   dataд8λ
*@return	
*/
void IINCHIP_WRITE( uint32 addrbsb,  uint8 data)
{
	iinchip_csoff();                              		
	IINCHIP_SpiSendData( (addrbsb & 0x00FF0000)>>16);	
	IINCHIP_SpiSendData( (addrbsb & 0x0000FF00)>> 8);
	IINCHIP_SpiSendData( (addrbsb & 0x000000F8) + 4);  
	IINCHIP_SpiSendData(data);                   
	iinchip_cson();                            
}

/**
*@brief		W5500һ8λ
*@param		addrbsb: дݵĵַ
*@param   dataдĵַȡ8λ
*@return	
*/
uint8 IINCHIP_READ(uint32 addrbsb)
{
	uint8 data = 0;
	iinchip_csoff();                            
	IINCHIP_SpiSendData( (addrbsb & 0x00FF0000)>>16);
	IINCHIP_SpiSendData( (addrbsb & 0x0000FF00)>> 8);
	IINCHIP_SpiSendData( (addrbsb & 0x000000F8))    ;
	data = IINCHIP_SpiSendData(0x00);            
	iinchip_cson();                               
	return data;    
}

/**
*@brief		W5500дlenֽ
*@param		addrbsb: дݵĵַ
*@param   bufдַ
*@param   lenַ
*@return	lenַ
*/
uint16 wiz_write_buf(uint32 addrbsb,uint8* buf,uint16 len)
{
	uint16 idx = 0;
	if(len == 0){ //printf(" Unexpected2 length 0\r\n");
	}
	iinchip_csoff();                               
	IINCHIP_SpiSendData( (addrbsb & 0x00FF0000)>>16);
	IINCHIP_SpiSendData( (addrbsb & 0x0000FF00)>> 8);
	IINCHIP_SpiSendData( (addrbsb & 0x000000F8) + 4); 
	for(idx = 0; idx < len; idx++)
	{
		IINCHIP_SpiSendData(buf[idx]);
	}
	iinchip_cson();                           
	return len;  
}

/**
*@brief		W5500lenֽ
*@param		addrbsb: ȡݵĵַ
*@param 	bufŶȡ
*@param		lenַ
*@return	lenַ
*/
uint16 wiz_read_buf(uint32 addrbsb, uint8* buf,uint16 len)
{
  uint16 idx = 0;
  if(len == 0)
  {
    //printf(" Unexpected2 length 0\r\n");
  }
  iinchip_csoff();                                
  IINCHIP_SpiSendData( (addrbsb & 0x00FF0000)>>16);
  IINCHIP_SpiSendData( (addrbsb & 0x0000FF00)>> 8);
  IINCHIP_SpiSendData( (addrbsb & 0x000000F8));    
  for(idx = 0; idx < len; idx++)                   
  {
    buf[idx] = IINCHIP_SpiSendData(0x00);
  }
  iinchip_cson();                                  
  return len;
}

/**
*@brief		дϢEEPROM
*@param		
*@return	
*/
void write_config_to_eeprom(void)
{
#ifdef DEMO_W5500 //add by Gavin	
	uint16 dAddr=0;
	ee_WriteBytes(ConfigMsg.mac,dAddr,(uint8)EEPROM_MSG_LEN);				
	delay_ms(10);	
#endif	
}

/**
*@brief		EEPROMϢ
*@param		
*@return	
*/
void read_config_from_eeprom(void)
{
#ifdef DEMO_W5500 //add by Gavin
	ee_ReadBytes(EEPROM_MSG.mac,0,EEPROM_MSG_LEN);
	delay_us(10);
#endif
}

/**
*@brief		STM32ʱ2ʼ
*@param		
*@return	
*/
void timer2_init(void)
{
#ifdef DEMO_W5500 //add by Gavin	
	TIM2_Configuration();																		/* TIM2 ʱ */
	TIM2_NVIC_Configuration();															/* ʱжȼ */
	RCC_APB1PeriphClockCmd(RCC_APB1Periph_TIM2 , ENABLE);		/* TIM2 ¿ʱӣʼʱ */
#endif
}

/**
*@brief		dhcpõĶʱʼ
*@param		
*@return	
*/
void dhcp_timer_init(void)
{
  timer2_init();																	
}

/**
*@brief		ntpõĶʱʼ
*@param		
*@return	
*/
void ntp_timer_init(void)
{
  timer2_init();																	
}

/**
*@brief		ʱ2жϺ
*@param		
*@return	
*/
#ifdef DEMO_W5500 //add by Gavin	
void timer2_isr(void)
{

  ms++;	
  if(ms>=1000)
  {  
    ms=0;
    dhcp_time++;			/*DHCPʱ1S*/
	#ifndef	__NTP_H__
	ntptimer++;				/*NTPʱ1S*/
	#endif
  }
}
#else
void timer2_isr(void)
{
//called by 20ms
  if(++ms>=50)
  {  
    ms=0;
    dhcp_time++;			/*DHCPʱ1S*/
	#ifndef	__NTP_H__
	ntptimer++;				/*NTPʱ1S*/
	#endif
  }	
}	
#endif

/**
*@brief		STM32ϵͳλ
*@param		
*@return	
*/
void reboot(void)
{
#ifdef DEMO_W5500 //add by Gavin
  pFunction Jump_To_Application;
  uint32 JumpAddress;
  //printf(" ϵͳС\r\n");
  JumpAddress = *(vu32*) (0x00000004);
  Jump_To_Application = (pFunction) JumpAddress;
  Jump_To_Application();
#endif
}




//----------------------------------- NEXT add by Gavin ----------------------------------------------------------------


//see BASE protocol 5.2.9		TCPIP
struct tcpip_STR{
	unsigned char ip_addr[4];
	unsigned char mac_addr[6];	
	unsigned char subnet_mask[4];
	unsigned char gateway[4];	
#define 	IP_ADDR_LEN 	4
#define 	MAC_ADDR_LEN 	6
#define 	SUBNET_ADDR_LEN 	4
#define 	GATEWAY_ADDR_LEN 	4	
};
struct tcpip_STR tcp_ip;

#define 	STORE_IP_ADDR								0x120	//len=4+1
#define 	STORE_MAC_ADDR							0x128 //len=6+1
#define 	STORE_SUBNET_ADDR						0x130	//len=4+1
#define 	STORE_GATEWAY_ADDR					0x138 //len=4+1

#define 	W5500_STORE_FLAG		0x5A




//--------------------------------------------------------------------
static void w5500_set_mac_addr(void){
	memcpy(ConfigMsg.mac,tcp_ip.mac_addr, 6);//	memcpy(ConfigMsg.mac, mac, 6);
	setSHAR(ConfigMsg.mac);	
}

static void w5500_set_ip_addr(void){
	memcpy(ConfigMsg.lip,tcp_ip.ip_addr,4);
	setSIPR(ConfigMsg.lip);
}

static void w5500_set_sub_addr(void){
	memcpy(ConfigMsg.sub,tcp_ip.subnet_mask,4);
	setSUBR(ConfigMsg.sub);
}

static void w5500_set_getway_addr(void){
	memcpy(ConfigMsg.gw,tcp_ip.gateway,4);
	setGAR(ConfigMsg.gw);
}



/*
w5500!!!
*/
static void setting_w5500_parameter(void)
{
	memcpy(ConfigMsg.mac,tcp_ip.mac_addr, 6);//	memcpy(ConfigMsg.mac, mac, 6);
	setSHAR(ConfigMsg.mac);	/**/
	memcpy(DHCP_GET.mac, tcp_ip.mac_addr, 6);//	memcpy(DHCP_GET.mac, mac, 6);	

  //ƶϢýṹ/
	memcpy(ConfigMsg.mac, tcp_ip.mac_addr, 6);
	
	
	memcpy(ConfigMsg.lip,tcp_ip.ip_addr,4);
	memcpy(ConfigMsg.sub,tcp_ip.subnet_mask,4);
	memcpy(ConfigMsg.gw,tcp_ip.gateway,4);
	
	memcpy(ConfigMsg.dns,dns_server,4);	
		
	/*IPϢдW5500ӦĴ*/	
	setSUBR(ConfigMsg.sub);
	setGAR(ConfigMsg.gw);
	setSIPR(ConfigMsg.lip);
}



/*
#define 	STORE_IP_ADDR								0x120	//len=4+1
#define 	STORE_MAC_ADDR							0x128 //len=6+1
#define 	STORE_SUBNET_ADDR						0x130	//len=4+1
#define 	STORE_GATEWAY_ADDR					0x138 //len=4+1
* sdk/PCòϢ
*/
void _0x61_tcpip_sub(const unsigned char *rxpc)
{
		unsigned char ack_buf[32],ack_len,wtmp[8];
		unsigned char op_flag =0;
		
		switch(rxpc[4]){

			case 2:
				memcpy(tcp_ip.ip_addr,rxpc+5,IP_ADDR_LEN);
				w5500_set_ip_addr();//
				memcpy(wtmp+1,tcp_ip.ip_addr,IP_ADDR_LEN);
				wtmp[0] =W5500_STORE_FLAG;
				platform.e2prom_write(STORE_IP_ADDR,wtmp,IP_ADDR_LEN+1);
			case 1: //read ip addr
				ack_buf[0] =1;
				memcpy(ack_buf+1,tcp_ip.ip_addr,IP_ADDR_LEN);
				ack_len =IP_ADDR_LEN;
				op_flag =1; 
				break;
			
			case 4:
				memcpy(tcp_ip.mac_addr,rxpc+5,MAC_ADDR_LEN);
				w5500_set_mac_addr();//
				memcpy(wtmp+1,tcp_ip.mac_addr,MAC_ADDR_LEN);
				wtmp[0] =W5500_STORE_FLAG;			
				platform.e2prom_write(STORE_MAC_ADDR,wtmp,MAC_ADDR_LEN+1);
			case 3: //read mac_addr addr
				ack_buf[0] =3;
				memcpy(ack_buf+1,tcp_ip.mac_addr,MAC_ADDR_LEN);
				ack_len =MAC_ADDR_LEN;
				op_flag =1;
				break;	

			case 6:
				memcpy(tcp_ip.subnet_mask,rxpc+5,SUBNET_ADDR_LEN);
				w5500_set_sub_addr();
				memcpy(wtmp+1,tcp_ip.subnet_mask,SUBNET_ADDR_LEN);
				wtmp[0] =W5500_STORE_FLAG;				
				platform.e2prom_write(STORE_SUBNET_ADDR,wtmp,SUBNET_ADDR_LEN+1);
			case 5: //read subnet_mask addr
				ack_buf[0] =5;
				memcpy(ack_buf+1,tcp_ip.subnet_mask,SUBNET_ADDR_LEN);
				ack_len =SUBNET_ADDR_LEN;
				op_flag =1;			
				break;	
			
			case 8:
				memcpy(tcp_ip.gateway,rxpc+5,GATEWAY_ADDR_LEN);
				w5500_set_getway_addr();
				memcpy(wtmp+1,tcp_ip.gateway,GATEWAY_ADDR_LEN);
				wtmp[0] =W5500_STORE_FLAG;			
				platform.e2prom_write(STORE_GATEWAY_ADDR,wtmp,GATEWAY_ADDR_LEN+1);
			case 7: //read gateway addr
				ack_buf[0] =7;
				memcpy(ack_buf+1,tcp_ip.gateway,GATEWAY_ADDR_LEN);
				ack_len =GATEWAY_ADDR_LEN;
				op_flag =1;			
				break;		
			
			default:break;
		}//sw	

		if(op_flag){
			user__pc_cmd_ack(0x61,12,ack_buf,ack_len+1);
		}
}


/*
* E2promеָλöȡW5500Ĳϵʼ
* ʼW5500 :
 setting parameter;
*/
static void read_w5500_parameter(void)
{
		unsigned char tmp[8];
		//12 TCP IP settting 
		//ip
		platform.e2prom_read(STORE_IP_ADDR,tmp,IP_ADDR_LEN+1);
		if(tmp[0] ==W5500_STORE_FLAG ){
			memcpy(tcp_ip.ip_addr,tmp+1,IP_ADDR_LEN);		
		}
		else{
			tcp_ip.ip_addr[0] = 192;
			tcp_ip.ip_addr[1] = 168;
			tcp_ip.ip_addr[2] = 0;
			tcp_ip.ip_addr[3] = 12;			
		}
		
		//mac
		 platform.e2prom_read(STORE_MAC_ADDR,tmp,MAC_ADDR_LEN+1);
		if( tmp[0] ==W5500_STORE_FLAG ){
			memcpy(tcp_ip.mac_addr,tmp+1,MAC_ADDR_LEN);						
		}
		else{
			tcp_ip.mac_addr[0] = 0x00;
			tcp_ip.mac_addr[1] = 0x08;
			tcp_ip.mac_addr[2] = 0xdc;
			tcp_ip.mac_addr[3] = 0x11;
			tcp_ip.mac_addr[4] = 0x11;
			tcp_ip.mac_addr[5] = 0x11;					
		}	
		
		//subnet
		platform.e2prom_read(STORE_SUBNET_ADDR,tmp,SUBNET_ADDR_LEN+1);
		if(tmp[0] == W5500_STORE_FLAG ){
			memcpy(tcp_ip.subnet_mask,tmp+1,SUBNET_ADDR_LEN);							
		}
		else{
			tcp_ip.subnet_mask[0] = 255;
			tcp_ip.subnet_mask[1] = 255;
			tcp_ip.subnet_mask[2] = 255;
			tcp_ip.subnet_mask[3] = 0;			
		}
		
		//gateway
		platform.e2prom_read(STORE_GATEWAY_ADDR,tmp,GATEWAY_ADDR_LEN+1);
		if(tmp[0] ==W5500_STORE_FLAG ){
			memcpy(tcp_ip.gateway,tmp+1,GATEWAY_ADDR_LEN);							
		}
		else{
			tcp_ip.gateway[0] = 200;
			tcp_ip.gateway[1] = 200;
			tcp_ip.gateway[2] = 100;
			tcp_ip.gateway[3] = 1;			
		}
		
}




/*
* ʼW5500 
* ʼio; rest ; setting ip mac
*/
void w5500_init(void)
{
	if( !function.TCPIP__SW) return ;
	
  gpio_for_w5500_config();							/*ʼMCU*/
  reset_w5500();												/*ӲλW5500*/
	
	//useing to test spi communicationadd by Gavin 
	//w5500_ver = IINCHIP_READ(VERSIONR);	
	
//  PHY_check();													/*Ƿ*/   
//  set_w5500_mac();											/*MACַ*/
//  set_w5500_ip();												/*IPַ*/	
	read_w5500_parameter();	
	setting_w5500_parameter();//
	
  socket_buf_init(txsize, rxsize);			/*ʼ8SocketķͽջС*/
}








