#ifndef _AES_H
#define _AES_H

#define RoundKeyLEN  300
//#define AES256MODE   //AES256 AES128 --ʵֵ
#define AES256EN  //֧AES256

#include "crypto.h"  //STM32ļܿӿ

//void AES_Encrypt(char* pExpressText , char* pCipherText , char* pAeskey);
//void AES_Decrypt(char* pExpressText , char* pCipherText , char* pAeskey);

//void AES_Test(void);


void AES_Encrypt(char* pExpressText , char* pCipherText  , char* pAeskey,unsigned char _256_mode);

void AES_Decrypt(char* pExpressText , char* pCipherText , char* pAeskey,unsigned char _256_mode);

/**
  * @brief  AES ECB Decryption example.
  * @param  InputMessage: pointer to input message to be decrypted.
  * @param  InputMessageLength: input data message length in byte.
  * @param  AES128_Key: pointer to the AES key to be used in the operation
  * @param  OutputMessage: pointer to output parameter that will handle the decrypted message
  * @param  OutputMessageLength: pointer to decrypted message length.
  * @retval error status: can be AES_SUCCESS if success or one of
  *         AES_ERR_BAD_INPUT_SIZE, AES_ERR_BAD_OPERATION, AES_ERR_BAD_CONTEXT
  *         AES_ERR_BAD_PARAMETER if error occured.
  */
int32_t STM32_AES_ECB_Decrypt(uint8_t* InputMessage,
                              uint32_t InputMessageLength,
                              uint8_t  *AES256_Key,
                              uint8_t  *OutputMessage,
                              uint32_t *OutputMessageLength,unsigned char _256_mode);
															
															
/**
  * @brief  AES ECB Encryption example.
  * @param  InputMessage: pointer to input message to be encrypted.
  * @param  InputMessageLength: input data message length in byte.
  * @param  AES128_Key: pointer to the AES key to be used in the operation
  * @param  OutputMessage: pointer to output parameter that will handle the encrypted message
  * @param  OutputMessageLength: pointer to encrypted message length.
  * @retval error status: can be AES_SUCCESS if success or one of
  *         AES_ERR_BAD_INPUT_SIZE, AES_ERR_BAD_OPERATION, AES_ERR_BAD_CONTEXT
  *         AES_ERR_BAD_PARAMETER if error occured.
  */
int32_t STM32_AES_ECB_Encrypt(uint8_t* InputMessage,
                              uint32_t InputMessageLength,
                              uint8_t  *AES256_Key,
                              uint8_t  *OutputMessage,
                              uint32_t *OutputMessageLength,unsigned char _256_mode);															
															
															
extern const uint8_t rsbox[256];	


#endif
